import re


DISPOSABLE_EMAIL_DOMAINS = {
    "mailinator.com",
    "tempmail.com",
    "10minutemail.com",
}


def is_valid_name(name):
    return not re.search(r"https?://|www\.|\.com|\.net|\.org|<a\s|href=|@", name, re.IGNORECASE)


def is_disposable_email(email):
    domain = email.split("@")[-1].lower()
    return domain in DISPOSABLE_EMAIL_DOMAINS


def is_valid_mobile(mobile):
    return re.fullmatch(r"\+?\d{7,15}", mobile or "") is not None
