import os
from werkzeug.utils import secure_filename


ALLOWED_EXTENSIONS = {"jpg", "jpeg", "png", "pdf"}


def allowed_file(filename):
    return "." in filename and filename.rsplit(".", 1)[1].lower() in ALLOWED_EXTENSIONS


def save_upload(file_storage, upload_folder):
    filename = secure_filename(file_storage.filename)
    file_path = os.path.join(upload_folder, filename)
    file_storage.save(file_path)
    file_type = filename.rsplit(".", 1)[1].lower()
    file_size = os.path.getsize(file_path)
    return filename, file_path, file_type, file_size
