from datetime import datetime
from app.extensions import db


class Cashier(db.Model):
    __tablename__ = "cashier"

    id = db.Column(db.Integer, primary_key=True)
    name = db.Column(db.String(100), nullable=False)
    status = db.Column(db.String(20), default="active")
    created_at = db.Column(db.DateTime, default=datetime.utcnow)

    user_id = db.Column(db.Integer, db.ForeignKey("user.id"))
    user = db.relationship("User", backref="cashiers")


class SavingsPlanType(db.Model):
    __tablename__ = "savings_plan_type"

    id = db.Column(db.Integer, primary_key=True)
    name = db.Column(db.String(50), nullable=False)
    min_period = db.Column(db.Integer)
    monthly_saving_amount = db.Column(db.Float, nullable=False)
    charity_amount = db.Column(db.Float, nullable=False)
    created_at = db.Column(db.DateTime, default=datetime.utcnow)


class CharityType(db.Model):
    __tablename__ = "charity_type"

    id = db.Column(db.Integer, primary_key=True)
    charity_type = db.Column(db.String(100), nullable=False)
    status = db.Column(db.String(20), default="active")
    created_at = db.Column(db.DateTime, default=datetime.utcnow)


class SavingsPlanMember(db.Model):
    __tablename__ = "savings_plan_member"

    id = db.Column(db.Integer, primary_key=True)
    member_id = db.Column(db.String(20), unique=True, nullable=False)
    member_short_name = db.Column(db.String(50), nullable=False)
    user_id = db.Column(db.Integer, db.ForeignKey("user.id"), nullable=False)
    plan_type_id = db.Column(db.Integer, db.ForeignKey("savings_plan_type.id"), nullable=False)
    cashier_id = db.Column(db.Integer, db.ForeignKey("cashier.id"), nullable=False)
    effective_date = db.Column(db.Date, nullable=False)
    end_date = db.Column(db.Date, nullable=True)
    status = db.Column(db.String(20), default="active")
    created_at = db.Column(db.DateTime, default=datetime.utcnow)

    user = db.relationship("User", backref="savings_memberships")
    plan_type = db.relationship("SavingsPlanType", backref="members", foreign_keys=[plan_type_id])
    cashier = db.relationship("Cashier", backref="members", foreign_keys=[cashier_id])
