from flask_sqlalchemy import SQLAlchemy
from flask_migrate import Migrate
from flask_mail import Mail
from flask_jwt_extended import JWTManager
from flask_cors import CORS


db = SQLAlchemy()
migrate = Migrate()
mail = Mail()
jwt = JWTManager()


def init_cors(app):
    CORS(
        app,
        supports_credentials=True,
        resources={r"/api/*": {"origins": app.config.get("CORS_ORIGINS", "*")}},
    )
